<?php
/**
 * This is a core PHP file. For customization, create a file in the folder /custom/.
 * Files with the same filename in this folder will automatically be loaded instead of the current file
 */

namespace hostfact;

use Service_Model;
use Cache;

class CST_Model extends Service_Model
{
    public array $TypeInformation;

	public function __construct()
	{
		$this->Error = $this->Warning = $this->Success = array();
		$this->TypeInformation = $this->ProductCustomFields = $this->ServiceCustomFields = $this->ProductInformation = array();
	}

	/** Get all cst from debtor, based on filters
	 *
	 * @return bool
	 */
	public function listCST()
	{
		$result = $this->APIRequest('cst', 'list', array('status' => 'active|suspended|error'), array('cacheable' => false));

		if($result === FALSE || !isset($result['cst']))
		{
			return [FALSE, null];
		}

		return [$result['cst'], $result['types']];
	}

	public function show()
	{
		if(!is_numeric($this->id))
		{
			$this->Error[] = __('invalid identifier');
			return FALSE;
		}

		$result = $this->APIRequest('cst', 'show', array('Identifier' => $this->id), array('useAPIError' => FALSE));

		if($result === FALSE)
		{
			$this->Error[] = __('cst does not exist');
			return FALSE;
		}

		foreach($result['cst'] as $key => $value)
		{
			$this->{$key} = $value;
		}

        if (isset($result['type'])) {
            $this->TypeInformation = $result['type'];
        }

        if (isset($result['product'])) {
            $this->ProductInformation = $result['product'];
        }

        if (isset($result['customfields'])) {
            if (isset($result['customfields']['Service'])) {
                $this->ServiceCustomFields = $result['customfields']['Service'];
            }
            if (isset($result['customfields']['Product'])) {
                $this->ProductCustomFields = $result['customfields']['Product'];
            }
        }

		return TRUE;
	}
}