<?php

// Require to load the generic PayNL payment module.
try {
    $paynl_module = dirname(__FILE__, 2) . '/paynl/payment_provider.php';
    require_once($paynl_module);
} catch (Exception $e) {
    exit(sprintf('PayNL ideal requires the generic PayNL payment method in: %s', $paynl_module));
}

class paynl_ideal extends paynl
{
    protected const PAYMENT_METHOD_ID = 10;

    protected function loadConfiguration()
    {
        $this->conf['PaymentDirectory'] = 'paynl.ideal';
        $this->conf['PaymentMethod'] = 'ideal';
    }

    public static function getBackofficeSettings()
    {
        $settings = parent::getBackofficeSettings();

        $settings['InternalName'] = 'Pay.nl - iDEAL';
        $settings['Advanced']['Title'] = "iDEAL";
        $settings['Advanced']['Image'] = "ideal.png";
        $settings['Advanced']['Description'] = "Met iDEAL kunt u vertrouwd, veilig en gemakkelijk uw online aankopen afrekenen.";

        $settings['Advanced']['Extra'] = "";

        return $settings;
    }

    public function choosePaymentMethod()
    {
        return false;
    }

    public function validateChosenPaymentMethod()
    {
        return true;
    }
}
