<?php

// Require to load the generic PayNL payment module.
try {
    $paynl_module = dirname(__FILE__, 2) . '/paynl/payment_provider.php';
    require_once($paynl_module);
} catch (Exception $e) {
    exit(sprintf('PayNL creditcard requires the generic PayNL payment method in: %s', $paynl_module));
}

class paynl_creditcard extends paynl
{
    protected const PAYMENT_METHOD_ID = 706;

    protected function loadConfiguration()
    {
        $this->conf['PaymentDirectory'] = 'paynl.creditcard';
        $this->conf['PaymentMethod'] = 'other';
    }

    public static function getBackofficeSettings()
    {
        $settings = parent::getBackofficeSettings();

        $settings['InternalName'] = 'Pay.nl - Creditcard';
        $settings['Advanced']['Title'] = "Creditcard";
        $settings['Advanced']['Image'] = "creditcard.png";
        $settings['Advanced']['Description'] = "U kunt uw bestelling betalen via creditcard.";

        $settings['Advanced']['Extra'] = "";

        return $settings;
    }

    public function choosePaymentMethod()
    {
        return false;
    }

    public function validateChosenPaymentMethod()
    {
        return true;
    }
}
