$(function(){
    $('select[name=ProductTarget]').change(function(){
        if(this.value == 'all'){
            $('div.productgroup-choices').hide();
        }else{
            $('div.productgroup-choices').show();
            $('select[name=PeriodicElementsWithoutProduct]').val('no').change();
        }
    });

    $('select[name=IndexPeriodicElements]').change(function(){
        if(this.value == 'yes'){
            $('div.periodicelements-choices').show();
        }else{
            $('div.periodicelements-choices').hide();
        }
    });

    $('select[name=IndexationPriceProposition]').change(function(){
        if(this.value == 'yes'){
            $('div.pricepropoisition-choices').show();
        }else{
            $('div.pricepropoisition-choices').hide();
        }
    });

    $('form#PriceIndexationForm input[name^=Product], form#PriceIndexationForm input[name^=Periodic]').on('keyup change', function () {
        let deformat = deformatAsMoney($(this).val());
        if (isNaN(deformat)) {
            $(this).addClass('error');
            $(this).parent().siblings('td.new_price').text('');
        } else {
            $(this).removeClass('error');
            let value = parseFloat(deformatAsMoney($(this).val()));
            let vat = parseFloat($(this).data('vat'));
            value = ($(this).data('vattype') === 'incl') ? value / (1 + vat) : value * (1 + vat);
            $(this).parent().siblings('td.new_price').text(formatAsMoney(value, 2));
        }
    });

    if ($('form#PriceIndexationForm').hasClass('error')) {
        $('form#PriceIndexationForm input').change();
    }

    if ($('#PriceIndexationLoader').length) {
        process_indexation();
    }

    function process_indexation() {
        $.post("XMLRequest.php", { action: 'process_priceindexation', random: Math.random() }, function(data) {
            if (data) {
                if ('progress' in data) {
                    $('p.loading_bar_text').text(`${data.progress}%`);
                    $('div.loading_bar_done').css('width', `${data.progress}%`);
                }

                if ('completed' in data) {
                    if (!data.completed) {
                        process_indexation();
                    } else {
                        if ($('#PriceIndexationErrors ul li').length) {
                            $('#PriceIndexationCompletedWithErrors').show();
                        } else {
                            $('#PriceIndexationCompleted').show();
                        }
                    }
                }

                if ('errors' in data && data.errors.length) {
                    for(var i=0; i < data.errors.length; i++)
                    {
                        $('#PriceIndexationErrors ul').append('<li>' + data.errors[i] + '</li>');
                    }
                    $('#PriceIndexationErrors').show();
                }
            }
        }, 'json');
    }
});