<?php
/**
 * HookApi
 * PHP version 7.2
 *
 * @category Class
 * @package  EConnect\Psb
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * PSB API 1.0
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: 1.0
 * Contact: techsupport@econnect.eu
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.2.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace EConnect\Psb\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use EConnect\Psb\ApiException;
use EConnect\Psb\Configuration;
use EConnect\Psb\HeaderSelector;
use EConnect\Psb\ObjectSerializer;

/**
 * HookApi Class Doc Comment
 *
 * @category Class
 * @package  EConnect\Psb
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class HookApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation getHooks
     *
     * Get registered hooks.
     *
     * @param  string $party_id The partyId of the registered hooks. (required)
     *
     * @throws \EConnect\Psb\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \EConnect\Psb\Model\Hook[]
     */
    public function getHooks($party_id)
    {
        list($response) = $this->getHooksWithHttpInfo($party_id);
        return $response;
    }

    /**
     * Operation getHooksWithHttpInfo
     *
     * Get registered hooks.
     *
     * @param  string $party_id The partyId of the registered hooks. (required)
     *
     * @throws \EConnect\Psb\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \EConnect\Psb\Model\Hook[], HTTP status code, HTTP response headers (array of strings)
     */
    public function getHooksWithHttpInfo($party_id)
    {
        $request = $this->getHooksRequest($party_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\EConnect\Psb\Model\Hook[]' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EConnect\Psb\Model\Hook[]', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\EConnect\Psb\Model\Hook[]';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EConnect\Psb\Model\Hook[]',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getHooksAsync
     *
     * Get registered hooks.
     *
     * @param  string $party_id The partyId of the registered hooks. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getHooksAsync($party_id)
    {
        return $this->getHooksAsyncWithHttpInfo($party_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getHooksAsyncWithHttpInfo
     *
     * Get registered hooks.
     *
     * @param  string $party_id The partyId of the registered hooks. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getHooksAsyncWithHttpInfo($party_id)
    {
        $returnType = '\EConnect\Psb\Model\Hook[]';
        $request = $this->getHooksRequest($party_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getHooks'
     *
     * @param  string $party_id The partyId of the registered hooks. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getHooksRequest($party_id)
    {
        // verify the required parameter 'party_id' is set
        if ($party_id === null || (is_array($party_id) && count($party_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $party_id when calling getHooks'
            );
        }
        if (!preg_match("/[A-Za-z0-9-=:]+/", $party_id)) {
            throw new \InvalidArgumentException("invalid value for \"party_id\" when calling HookApi.getHooks, must conform to the pattern /[A-Za-z0-9-=:]+/.");
        }


        $resourcePath = '/api/v1/{partyId}/hook';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($party_id !== null) {
            $resourcePath = str_replace(
                '{' . 'partyId' . '}',
                ObjectSerializer::toPathValue($party_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Subscription-Key');
        if ($apiKey !== null) {
            $headers['Subscription-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation sendHookPing
     *
     * Send ping to hook(s).
     *
     * @param  string $party_id The partyId where the ping must be send to. (required)
     *
     * @throws \EConnect\Psb\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \EConnect\Psb\Model\Document
     */
    public function sendHookPing($party_id)
    {
        list($response) = $this->sendHookPingWithHttpInfo($party_id);
        return $response;
    }

    /**
     * Operation sendHookPingWithHttpInfo
     *
     * Send ping to hook(s).
     *
     * @param  string $party_id The partyId where the ping must be send to. (required)
     *
     * @throws \EConnect\Psb\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \EConnect\Psb\Model\Document, HTTP status code, HTTP response headers (array of strings)
     */
    public function sendHookPingWithHttpInfo($party_id)
    {
        $request = $this->sendHookPingRequest($party_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\EConnect\Psb\Model\Document' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EConnect\Psb\Model\Document', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\EConnect\Psb\Model\Document';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EConnect\Psb\Model\Document',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation sendHookPingAsync
     *
     * Send ping to hook(s).
     *
     * @param  string $party_id The partyId where the ping must be send to. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function sendHookPingAsync($party_id)
    {
        return $this->sendHookPingAsyncWithHttpInfo($party_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation sendHookPingAsyncWithHttpInfo
     *
     * Send ping to hook(s).
     *
     * @param  string $party_id The partyId where the ping must be send to. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function sendHookPingAsyncWithHttpInfo($party_id)
    {
        $returnType = '\EConnect\Psb\Model\Document';
        $request = $this->sendHookPingRequest($party_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'sendHookPing'
     *
     * @param  string $party_id The partyId where the ping must be send to. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function sendHookPingRequest($party_id)
    {
        // verify the required parameter 'party_id' is set
        if ($party_id === null || (is_array($party_id) && count($party_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $party_id when calling sendHookPing'
            );
        }
        if (!preg_match("/[A-Za-z0-9-=:]+/", $party_id)) {
            throw new \InvalidArgumentException("invalid value for \"party_id\" when calling HookApi.sendHookPing, must conform to the pattern /[A-Za-z0-9-=:]+/.");
        }


        $resourcePath = '/api/v1/{partyId}/hook/ping';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($party_id !== null) {
            $resourcePath = str_replace(
                '{' . 'partyId' . '}',
                ObjectSerializer::toPathValue($party_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Subscription-Key');
        if ($apiKey !== null) {
            $headers['Subscription-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation subscribe
     *
     * Add or update hook.
     *
     * @param  string $party_id The partyId for the hook. (required)
     * @param  \EConnect\Psb\Model\Hook $hook The hook that will define the action and trigger. (required)
     *
     * @throws \EConnect\Psb\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return |\EConnect\Psb\Model\Hook
     */
    public function subscribe($party_id, $hook)
    {
        list($response) = $this->subscribeWithHttpInfo($party_id, $hook);
        return $response;
    }

    /**
     * Operation subscribeWithHttpInfo
     *
     * Add or update hook.
     *
     * @param  string $party_id The partyId for the hook. (required)
     * @param  \EConnect\Psb\Model\Hook $hook The hook that will define the action and trigger. (required)
     *
     * @throws \EConnect\Psb\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of |\EConnect\Psb\Model\Hook, HTTP status code, HTTP response headers (array of strings)
     */
    public function subscribeWithHttpInfo($party_id, $hook)
    {
        $request = $this->subscribeRequest($party_id, $hook);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\EConnect\Psb\Model\Hook' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\EConnect\Psb\Model\Hook', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\EConnect\Psb\Model\Hook';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\EConnect\Psb\Model\Hook',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation subscribeAsync
     *
     * Add or update hook.
     *
     * @param  string $party_id The partyId for the hook. (required)
     * @param  \EConnect\Psb\Model\Hook $hook The hook that will define the action and trigger. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function subscribeAsync($party_id, $hook)
    {
        return $this->subscribeAsyncWithHttpInfo($party_id, $hook)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation subscribeAsyncWithHttpInfo
     *
     * Add or update hook.
     *
     * @param  string $party_id The partyId for the hook. (required)
     * @param  \EConnect\Psb\Model\Hook $hook The hook that will define the action and trigger. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function subscribeAsyncWithHttpInfo($party_id, $hook)
    {
        $returnType = '\EConnect\Psb\Model\Hook';
        $request = $this->subscribeRequest($party_id, $hook);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'subscribe'
     *
     * @param  string $party_id The partyId for the hook. (required)
     * @param  \EConnect\Psb\Model\Hook $hook The hook that will define the action and trigger. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function subscribeRequest($party_id, $hook)
    {
        // verify the required parameter 'party_id' is set
        if ($party_id === null || (is_array($party_id) && count($party_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $party_id when calling subscribe'
            );
        }
        if (!preg_match("/[A-Za-z0-9-=:]+/", $party_id)) {
            throw new \InvalidArgumentException("invalid value for \"party_id\" when calling HookApi.subscribe, must conform to the pattern /[A-Za-z0-9-=:]+/.");
        }

        // verify the required parameter 'hook' is set
        if ($hook === null || (is_array($hook) && count($hook) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $hook when calling subscribe'
            );
        }

        $resourcePath = '/api/v1/{partyId}/hook';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($party_id !== null) {
            $resourcePath = str_replace(
                '{' . 'partyId' . '}',
                ObjectSerializer::toPathValue($party_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($hook)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($hook));
            } else {
                $httpBody = $hook;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Subscription-Key');
        if ($apiKey !== null) {
            $headers['Subscription-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation unSubscribe
     *
     * Delete hook.
     *
     * @param  string $party_id The partyId for the hook. (required)
     * @param  string $hook_id The hookId that is used as the id in the hook object. (required)
     *
     * @throws \EConnect\Psb\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function unSubscribe($party_id, $hook_id)
    {
        $this->unSubscribeWithHttpInfo($party_id, $hook_id);
    }

    /**
     * Operation unSubscribeWithHttpInfo
     *
     * Delete hook.
     *
     * @param  string $party_id The partyId for the hook. (required)
     * @param  string $hook_id The hookId that is used as the id in the hook object. (required)
     *
     * @throws \EConnect\Psb\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function unSubscribeWithHttpInfo($party_id, $hook_id)
    {
        $request = $this->unSubscribeRequest($party_id, $hook_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation unSubscribeAsync
     *
     * Delete hook.
     *
     * @param  string $party_id The partyId for the hook. (required)
     * @param  string $hook_id The hookId that is used as the id in the hook object. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function unSubscribeAsync($party_id, $hook_id)
    {
        return $this->unSubscribeAsyncWithHttpInfo($party_id, $hook_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation unSubscribeAsyncWithHttpInfo
     *
     * Delete hook.
     *
     * @param  string $party_id The partyId for the hook. (required)
     * @param  string $hook_id The hookId that is used as the id in the hook object. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function unSubscribeAsyncWithHttpInfo($party_id, $hook_id)
    {
        $returnType = '';
        $request = $this->unSubscribeRequest($party_id, $hook_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'unSubscribe'
     *
     * @param  string $party_id The partyId for the hook. (required)
     * @param  string $hook_id The hookId that is used as the id in the hook object. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function unSubscribeRequest($party_id, $hook_id)
    {
        // verify the required parameter 'party_id' is set
        if ($party_id === null || (is_array($party_id) && count($party_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $party_id when calling unSubscribe'
            );
        }
        if (!preg_match("/[A-Za-z0-9-=:]+/", $party_id)) {
            throw new \InvalidArgumentException("invalid value for \"party_id\" when calling HookApi.unSubscribe, must conform to the pattern /[A-Za-z0-9-=:]+/.");
        }

        // verify the required parameter 'hook_id' is set
        if ($hook_id === null || (is_array($hook_id) && count($hook_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $hook_id when calling unSubscribe'
            );
        }
        if (strlen($hook_id) > 64) {
            throw new \InvalidArgumentException('invalid length for "$hook_id" when calling HookApi.unSubscribe, must be smaller than or equal to 64.');
        }
        if (!preg_match("/[A-Za-z0-9-=]+/", $hook_id)) {
            throw new \InvalidArgumentException("invalid value for \"hook_id\" when calling HookApi.unSubscribe, must conform to the pattern /[A-Za-z0-9-=]+/.");
        }


        $resourcePath = '/api/v1/{partyId}/hook/{hookId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($party_id !== null) {
            $resourcePath = str_replace(
                '{' . 'partyId' . '}',
                ObjectSerializer::toPathValue($party_id),
                $resourcePath
            );
        }
        // path params
        if ($hook_id !== null) {
            $resourcePath = str_replace(
                '{' . 'hookId' . '}',
                ObjectSerializer::toPathValue($hook_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                []
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                [],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Subscription-Key');
        if ($apiKey !== null) {
            $headers['Subscription-Key'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
